#include "OnlinePresenceSony.h"
#include "SignInSony.h"
#include "MessagePipe.h"
#include "ErrorCodesSony.h"

using namespace sce::Toolkit::NP;
using namespace sce::Toolkit::NP::Utilities;

namespace UnityPlugin
{
	OnlinePresence gPresence;

	DO_EXPORT( ErrorCode, PrxSetPresence ) (const char* text)
	{
		return gPresence.SetPresence(text);
	}

	DO_EXPORT( bool, PrxSetPresenceIsBusy ) ()
	{
		return gPresence.IsBusy();
	}

	DO_EXPORT( bool, PrxPresenceGetLastError ) (ResultCode* result)
	{
		return gPresence.GetLastError(result);
	}

	OnlinePresence::OnlinePresence()
		: m_Busy(false)
		, m_LastResult("OnlinePresence")
	{
	}

	bool OnlinePresence::IsBusy()
	{
		SimpleLock::AutoLock lock(m_Lock);
		return m_Busy;
	}

	ErrorCode OnlinePresence::SetPresence(const char* text)
	{
		if(IsBusy())
		{
			return m_LastResult.SetResult(NP_ERR_BUSY, true);
		}

		SimpleLock::AutoLock lock(m_Lock);

		m_LastResult.Reset();

		PresenceDetails myPresence;

		memset(&myPresence, 0x00, sizeof(myPresence));
		myPresence.status = text;
//			myPresence.data = 0;
		myPresence.size = 0;
		int ret = Presence::Interface::setPresence(&myPresence, true);
		if (ret < 0 )
		{
			return m_LastResult.SetResultSCE(ret, true, __FUNCTION__, __LINE__);
		}

		m_Busy = true;

		return m_LastResult.GetResult();
	}

	bool OnlinePresence::ProcessEvent(const sce::Toolkit::NP::Event& event)
	{
		SimpleLock::AutoLock lock(m_Lock);
		bool handled = false;

		switch(event.event)
		{
			case Event::presenceSet:
				m_Busy = false;
				handled = true;
				Messages::AddMessage(Messages::kNPToolKit_PresenceSet);
				break;

			case Event::presenceSetFailed:
				m_LastResult.SetResultSCE(event.returnCode, true, __FUNCTION__, __LINE__);
				Messages::AddMessage(Messages::kNPToolKit_PresenceError);
				m_Busy = false;
				handled = true;
				break;


			default:
				Messages::LogWarning("Unexpected event from presence service: event=%d\n", event.event);
				break;
		}

		return handled;
	}

} // namespace UnityPlugin
